/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsConnectionCloseRequestPacket;
import com.ibm.hsc.filesvr.FsConnectionCloseResponsePacket;
import com.ibm.hsc.filesvr.FsConnectionInfoPacket;
import com.ibm.hsc.filesvr.FsConnectionInfoRequestPacket;
import com.ibm.hsc.filesvr.FsConnectionInfoResponsePacket;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsFileCloseRequestPacket;
import com.ibm.hsc.filesvr.FsFileCloseResponsePacket;
import com.ibm.hsc.filesvr.FsFileListPacket;
import com.ibm.hsc.filesvr.FsFileListRequestPacket;
import com.ibm.hsc.filesvr.FsFileListResponsePacket;
import com.ibm.hsc.filesvr.FsFileOpenRequestPacket;
import com.ibm.hsc.filesvr.FsFileOpenResponsePacket;
import com.ibm.hsc.filesvr.FsFileReadPacket;
import com.ibm.hsc.filesvr.FsFileReadRequestPacket;
import com.ibm.hsc.filesvr.FsFileReadResponsePacket;
import com.ibm.hsc.filesvr.FsPacket;
import com.ibm.hsc.filesvr.FsSystem;
import java.net.Socket;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public class FsClient
extends FsConnection {
    public static void main(String[] stringArray) {
        FsSystem.processArgs(stringArray);
        try {
            new FsClient(new Socket("localhost", 2125)).start();
        }
        catch (Exception exception) {
            System.out.println("FsClient.main: Exception caught");
            exception.printStackTrace();
        }
    }

    public FsClient(Socket socket) throws FsException {
        super(socket);
    }

    public void run() {
        try {
            Object object;
            Object object2;
            FsPacket fsPacket;
            FsConnectionInfoRequestPacket fsConnectionInfoRequestPacket = new FsConnectionInfoRequestPacket(this);
            fsConnectionInfoRequestPacket.setPacketSignature(1179844609);
            fsConnectionInfoRequestPacket.setPacketFeatureCode(65536);
            this.writePacket(fsConnectionInfoRequestPacket);
            FsPacket fsPacket2 = this.readPacket();
            if (fsPacket2 instanceof FsConnectionInfoResponsePacket) {
                fsPacket = (FsConnectionInfoResponsePacket)fsPacket2;
                this.trace("FsClient.run: Packet signature = " + Integer.toHexString(((FsConnectionInfoPacket)fsPacket).getPacketSignature()));
                this.trace("FsClient.run: Packet feature code = " + Integer.toHexString(((FsConnectionInfoPacket)fsPacket).getPacketFeatureCode()));
                this.trace("FsClient.run: Server id = " + ((FsConnectionInfoPacket)fsPacket).getServerId());
                this.trace("FsClient.run: Socket id = " + ((FsConnectionInfoPacket)fsPacket).getSocketId());
            } else {
                this.trace("FsClient.run: Expected FsConnectionInfoResponsePacket, received opcode = " + fsPacket2.getOpCode() + " with return code = " + fsPacket2.getReturnCode());
            }
            fsPacket = new FsFileListRequestPacket(this, 1);
            ((FsFileListPacket)fsPacket).setFileListFormat(3);
            this.writePacket(fsPacket);
            fsPacket2 = this.readPacket();
            Hashtable hashtable = null;
            if (fsPacket2 instanceof FsFileListResponsePacket) {
                object2 = (FsFileListResponsePacket)fsPacket2;
                this.trace("FsClient.run: Number of files returned = " + ((FsFileListResponsePacket)object2).getNumFiles());
                ((FsFileListResponsePacket)object2).printFileListInfo();
                hashtable = ((FsFileListResponsePacket)object2).getFileListHash();
            } else {
                this.trace("FsClient.run: Expected FsFileListResponsePacket, received opcode = " + fsPacket2.getOpCode() + " with return code = " + fsPacket2.getReturnCode());
            }
            if (hashtable != null && hashtable.size() > 0) {
                try {
                    FsPacket fsPacket3;
                    object2 = hashtable.keys();
                    object = (String)object2.nextElement();
                    this.writePacket(new FsFileOpenRequestPacket(this, 1, 1, (String)object));
                    fsPacket2 = this.readPacket();
                    if (fsPacket2 instanceof FsFileOpenResponsePacket) {
                        FsPacket fsPacket4;
                        fsPacket3 = (FsFileOpenResponsePacket)fsPacket2;
                        long l = ((FsFileOpenResponsePacket)fsPacket3).getFileHandle();
                        this.trace("FsClient.run: File handle = " + Long.toHexString(l));
                        this.writePacket(new FsFileReadRequestPacket(this, 0L, 0x100000, l));
                        fsPacket2 = this.readPacket();
                        if (fsPacket2 instanceof FsFileReadResponsePacket) {
                            fsPacket4 = (FsFileReadResponsePacket)fsPacket2;
                            this.trace("FsClient.run: Bytes read from file = " + ((FsFileReadPacket)fsPacket4).getReadLength());
                        } else {
                            this.trace("FsClient.run: Expected FsFileReadResponsePacket, received opcode = " + fsPacket2.getOpCode() + " with return code = " + fsPacket2.getReturnCode());
                        }
                        this.writePacket(new FsFileCloseRequestPacket((FsConnection)this, l));
                        fsPacket2 = this.readPacket();
                        if (fsPacket2 instanceof FsFileCloseResponsePacket) {
                            fsPacket4 = (FsFileCloseResponsePacket)fsPacket2;
                            if (fsPacket4.getReturnCode() == 0) {
                                this.trace("FsClient.run: File closed successfully");
                            } else {
                                this.trace("FsClient.run: Failure closing file = " + fsPacket4.getReturnCode());
                            }
                        } else {
                            this.trace("FsClient.run: Expected FsFileCloseResponsePacket, received opcode = " + fsPacket2.getOpCode() + " with return code = " + fsPacket2.getReturnCode());
                        }
                    } else {
                        this.trace("FsClient.run: Expected FsFileOpenResponsePacket, received opcode = " + fsPacket2.getOpCode() + " with return code = " + fsPacket2.getReturnCode());
                    }
                    this.trace("FsClient.run: Reading from file without open");
                    object = (String)object2.nextElement();
                    this.writePacket(new FsFileReadRequestPacket(this, 0L, 0x100000, 5, 1, (String)object));
                    fsPacket2 = this.readPacket();
                    if (fsPacket2 instanceof FsFileReadResponsePacket) {
                        fsPacket3 = (FsFileReadResponsePacket)fsPacket2;
                        this.trace("FsClient.run: Bytes read from file = " + ((FsFileReadPacket)fsPacket3).getReadLength());
                    } else {
                        this.trace("FsClient.run: Expected FsFileReadResponsePacket, received opcode = " + fsPacket2.getOpCode() + " with return code = " + fsPacket2.getReturnCode());
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    this.trace("FsClient.run: No more files to read from");
                }
            }
            object2 = new FsConnectionCloseRequestPacket(this);
            this.writePacket((FsPacket)object2);
            fsPacket2 = this.readPacket();
            if (fsPacket2 instanceof FsConnectionCloseResponsePacket) {
                object = (FsConnectionCloseResponsePacket)fsPacket2;
                if (((FsPacket)object).getReturnCode() == 0) {
                    this.trace("FsClient.run: Connection closed successfully");
                } else {
                    this.trace("FsClient.run: Failure closing connection = " + ((FsPacket)object).getReturnCode());
                }
            } else {
                this.trace("FsClient.run: Expected FsConnectionCloseResponsePacket, received opcode = " + fsPacket2.getOpCode() + " with return code = " + fsPacket2.getReturnCode());
            }
            this.close();
        }
        catch (Exception exception) {
            this.trace("FsClient.run: Exception caught", exception);
        }
    }
}

